; annotated program notes
; please use this for knowledge aquisition
; DONT submit this code
    
.cseg
.org 0x0000
    rjmp start

start:	
    ; stack pointer stuff (see 7.5.1)
    ; the stack pointer is 16 wide and has 2 reg for the low and high bytes
    ; RAMEND is 16 wide thus the need for the LOW and HIGH preprocessor directives
    ldi r16, LOW(RAMEND) ; load whatever is in the low byte of RAMEND
    out spl, r16 ;spl    ; write the reg contents to stack pointer low byte
    ldi r16, HIGH(RAMEND); ... same for high byte
    out sph, r16         ; ... same for high byte
    ; this is the ""default"" behavior for the chip but
    ; we are menually enforcing it here
    rjmp part1


; add the data points, then use the simulator to
; inspect the contents of the status registers
;; Write and assemble a program to add the following data and then use the simulator to examine
;; the S, V, N, Z and C flags after the execution of each addition.
;; Data: 0x92, 0x23, 0x66, 0x87, 0xF5
part1:
    ; In general we use reg r[16-25] in most cases,
    ; the rest have sepcial perposes.
    ldi r17, 0x92
    ldi r18, 0x23 ; S flag means negative number (ie. N ^ V)
    add r17, r18  ; SREG: 00010100
    
    ldi r18, 0x66 ;C flag set since the operation resulted in carry
    add r17, r18  ;SREG: 00000001
    
    ldi r18, 0x87 ; half carry flag set + S for sign change and N for negative result
    add r17, r18  ; SREG: 00110100
    
    ldi r18, 0xF5 ; S for sign change, N for negative value, C for carry
    add r17, r18  ; SREG: 0b00010101
    
    rjmp part2
   
; examine flags and reg content after each step
; check sec. 4 of the avr instruction set datasheet
part2:
    LDI R20, 0x27
    LDI R21, 0x15
    SUB R20, R21 ; nothing happened
    
    LDI R20, 0x20
    LDI R21, 0x15 ; SREG: 0b00100000
    SUB R20, R21  ; H: borrow from bit 3
    
    LDI R24, 95
    LDI R25, 95
    SUB R24, R25 ; zero flag since 95-95=0
    
    LDI R22, 50
    LDI R23, 70
    SUB R22, R23 
    ; SREG: 0b00110101
    ; bits: --ITHSVNZC
    ; bit H: borrow from bit 3
    ; bit S: sign change (if either bit N or V is set, then this is also set (we can see bit N is set)
    ; bit C: Carry bit (sub overflow due to obvious reasons)
    RJMP part3
  
; use the simulator to single-step the instructions
; pay attention to i/o contents and SREG
part3:
    LDI R20, 0     ;0b00000000
    LDI R21, 0xFF  ;0b11111111
    LDI R22, 0x11  ;0b00010001
    LDI R23, 0x22  ;0b00100010

    
    ; 8th bit (leftmost) is the sign bit
    ; 1: + ; 0: -
    ; then bits flipped for neg nums
    ; 0b00000001 -> 0b11111110
    COM R20        ;0b11111111
    COM R21        ;0b00000000
    COM R22        ;0b11101110
    COM R23        ;0b11011101
    ; the COM instr. is an implementation of ones' compliment
    ; COM is equivalent to doing a n * -1 operation
    ; NEG is the twos' compliment equivalend of COM
    
    RJMP part4
 
; inspect SREG after each operation
; this section mostly deals with stuff like overflows...
part4:
    
    ;a)
    nop
    ldi r20, 0x85
    ldi r21, 0x92 ; two compliment overflow with carry
    add r20, r21  ;SREG: 0b00011001
    
    ;b)
    ldi r16, 0x15
    ldi r17, 0x72 ; sreg N set due to sub being negative (0x15-0x72 < 0)
    add r16, r17  ;SREG: 0b00001100
    
    ;c)
    ldi r25, 0xF5
    ldi r26, 0x52 ; operation resulted in carry (C flag)
    add r25, r26  ;SREG: 0b00000001
    
    ;d)
    ldi r25, 0xFE ; overflow & zero result
    inc r25 ;SREG: 0b00010101 (S + N + Z)
    inc r25 ;SREG: 0b00000011
    rjmp part1