;;;;;;;;;;;;;;;;;;;;;;;
;; QUESTION 2
;;;;;;;;;;;;;;;;;;;;;;;

.dseg          ; data segment to be allocated in SRAM
.org 0x100     ; place at start of SRAM
value:
    .byte 0x3  ; reserve 3 bytes of sram

.cseg          ; code segment in program memory
.org 0x00      ; place at addr 0x00
    rjmp start ; branch to start

start:
    ldi r18, 0x0c       ; load hex val into r18
    ldi r16, 10         ; load decimal val into r16
    ldi r17, 0b00001001 ; load bin value into r17

    inc r16 ; inc register by +1 (11 | 0x0B)
    inc r17 ; inc register by +1 (0b00001010 | 0x0A)
    inc r18 ; inc register by +1 (0x0d)

    add r16, r17 ; add r16+r17 -> r16 (0x15)
    add r17, r18 ; add r17+r18 -> r17 (0x17)

    sts value, r16   ; write contents of r16 to addr of `value`
    sts value+1, r17 ; write contents of r17 to addr of `value` offset 1 byte
    sts value+2, r18 ; write contents of r18 to addr of `value` offset 2 bytes

    ; the above three lines will write the following string of values to the
    ; SRAM at address 0x100:
    ;       | 00 | 01 | 02 |
    ; ------|----|----|----|
    ; 0x100 | 15 | 17 | 0D |
    ; when addressing in sts, we refer to the label, but then add first
    ; 1 nibble, then 2 nibbles. Thus we get the 3 byte string in SRAM
    ; the first byte is '15' (hex for 0x0B + 0x0A)
    ; the second byte is '17' (hex for 0x0A + 0x0D)
    ; the third byte is '0D' since no operations were done on r18

    rjmp start ; loop indefinietly

;;;;;;;;;;;;;;;;;;;;;;;
;; QUESTION 3
;;;;;;;;;;;;;;;;;;;;;;;


#define SWITCH 7
.cseg
.org 0x0000
	rjmp start

start:
	ldi r17, 0xFF
	out DDRD, r17
	call readswitch

readswitch:
	sbic PINB, SWITCH
	rjmp readend

	rjmp readhold
readhold:
	sbis PINB, SWITCH
	rjmp readhold

readend:
	ldi r18, 0xFF   ; mask for flipping bits
	eor r17, r18    ; flip bits (effectively toggling the LED)
	out portd, r17  ; toggle button
	ret


;;;;;;;;;;;;;;;;;;;;;;;
;; QUESTION 4
;;;;;;;;;;;;;;;;;;;;;;;


#define SWITCH 7
.cseg
.org 0x0000
	rjmp start

start:
	ldi r16, 0x00 ; counter at zero
	ldi r17, 0x00 ; led off
	out DDRD, r17
	call readswitch

readswitch:
	sbic PINB, SWITCH
	rjmp readend

	inc r16
	cpi r16, 5
	brnq readhold
	ldi r17, 0xFF
	ldi r16, 0
readhold:
	sbis PINB, SWITCH
	rjmp readhold

readend:
	out portd, r17  ; write the state of r17 to the led
	ret
